#include "at.h"
#include "at_hw.h"

#ifdef SIOCETHTOOL
#include <asm/uaccess.h>

extern char at_driver_name[];
extern char at_driver_version[];
#ifdef SIOCGMIIPHY
extern int at_set_spd_dplx(struct at_adapter* adapter,uint16_t spddplx);
#endif 
extern int32_t at_up(struct at_adapter* adapter);
extern void at_down(struct at_adapter* adapter);
extern void at_reset(struct at_adapter* adapter);
extern int32_t at_setup_ring_resources(struct at_adapter* adapter);
extern void at_free_ring_resources(struct at_adapter* adapter);

#ifdef	ETHTOOL_GSTATS
struct at_stats {
	char stat_string[ETH_GSTRING_LEN];
	int sizeof_stat;
	int stat_offset;
};

#define AT_STAT(m) sizeof(((struct at_adapter *)0)->m), \
		      offsetof(struct at_adapter, m)
static struct at_stats at_gstrings_stats[] = {
	{ "rx_packets",             AT_STAT(soft_stats.rx_packets)          },
	{ "tx_packets",             AT_STAT(soft_stats.tx_packets)          },
	{ "rx_bytes",               AT_STAT(soft_stats.rx_bytes)            },
	{ "tx_bytes",               AT_STAT(soft_stats.tx_bytes)            },
	{ "rx_errors",              AT_STAT(soft_stats.rx_errors)           },
	{ "tx_errors",              AT_STAT(soft_stats.tx_errors)           },
	{ "rx_dropped",             AT_STAT(net_stats.rx_dropped)           },
	{ "tx_dropped",             AT_STAT(net_stats.tx_dropped)           },
	{ "multicast",              AT_STAT(soft_stats.multicast)           },
	{ "collisions",             AT_STAT(soft_stats.collisions)          },
	{ "rx_length_errors",       AT_STAT(soft_stats.rx_length_errors)    },
	{ "rx_over_errors",         AT_STAT(soft_stats.rx_missed_errors)    },
	{ "rx_crc_errors",          AT_STAT(soft_stats.rx_crc_errors)       },
	{ "rx_frame_errors",        AT_STAT(soft_stats.rx_frame_errors)     },
	{ "rx_fifo_errors",         AT_STAT(soft_stats.rx_fifo_errors)      },
	{ "rx_missed_errors",       AT_STAT(soft_stats.rx_missed_errors)    },
	{ "tx_aborted_errors",      AT_STAT(soft_stats.tx_aborted_errors)   },
	{ "tx_carrier_errors",      AT_STAT(soft_stats.tx_carrier_errors)   },
	{ "tx_fifo_errors",         AT_STAT(soft_stats.tx_fifo_errors)      },
	{ "tx_window_errors",       AT_STAT(soft_stats.tx_window_errors)    },
	{ "tx_abort_exce_coll",     AT_STAT(soft_stats.excecol)             },
	{ "tx_abort_late_coll",     AT_STAT(soft_stats.latecol)             },
	{ "tx_deferred_ok",         AT_STAT(soft_stats.deffer)              },
	{ "tx_single_coll_ok",      AT_STAT(soft_stats.scc)                 },
	{ "tx_multi_coll_ok",       AT_STAT(soft_stats.mcc)                 },
	{ "tx_underun",             AT_STAT(soft_stats.tx_underun)          },
	{ "tx_trunc",               AT_STAT(soft_stats.tx_trunc)            },
	{ "tx_pause",               AT_STAT(soft_stats.tx_pause)            },
	{ "rx_pause",               AT_STAT(soft_stats.rx_pause)            },
	{ "rx_rrd_ov",              AT_STAT(soft_stats.rx_rrd_ov)           },
	{ "rx_trunc",               AT_STAT(soft_stats.rx_trunc)            }
};
#define AT_STATS_LEN	\
	sizeof(at_gstrings_stats) / sizeof(struct at_stats)
#endif	/* ETHTOOL_GSTATS */

#ifdef	ETHTOOL_GWOL
static void
at_ethtool_gwol(struct at_adapter *adapter, struct ethtool_wolinfo *wol)
{
	wol->supported = 
	        WAKE_UCAST | WAKE_MCAST |
			 WAKE_BCAST | WAKE_MAGIC;

	wol->wolopts = 0;
	if(adapter->wol & AT_WUFC_EX)
		wol->wolopts |= WAKE_UCAST;
	if(adapter->wol & AT_WUFC_MC)
		wol->wolopts |= WAKE_MCAST;
	if(adapter->wol & AT_WUFC_BC)
		wol->wolopts |= WAKE_BCAST;
	if(adapter->wol & AT_WUFC_MAG)
		wol->wolopts |= WAKE_MAGIC;
	return;
	
}
#endif	/* ETHTOOL_GWOL */

#ifdef	ETHTOOL_SWOL
static int
at_ethtool_swol(struct at_adapter *adapter, struct ethtool_wolinfo *wol)
{
	if(wol->wolopts & (WAKE_PHY | WAKE_ARP | WAKE_MAGICSECURE))
		return -EOPNOTSUPP;

	adapter->wol = 0;

	if(wol->wolopts & WAKE_UCAST)
		adapter->wol |= AT_WUFC_EX;
	if(wol->wolopts & WAKE_MCAST)
		adapter->wol |= AT_WUFC_MC;
	if(wol->wolopts & WAKE_BCAST)
		adapter->wol |= AT_WUFC_BC;
	if(wol->wolopts & WAKE_MAGIC)
		adapter->wol |= AT_WUFC_MAG;
	

	return 0;
}
#endif	/* ETHTOOL_SWOL */

static int
at_ethtool_sset(struct at_adapter *adapter, struct ethtool_cmd *ecmd)
{
	struct at_hw *hw = &adapter->hw;
	uint16_t phy_data;
	int ret_val = 0;
        uint16_t old_media_type = hw->MediaType;
	
	if(netif_running(adapter->netdev)) {
	    at_down(adapter);
	}
	//michael add 2005-11-17
	DEBUGOUT("enter at_ethtool_sset---michael debug\n");
	if(ecmd->autoneg == AUTONEG_ENABLE) {
	    hw->MediaType = MEDIA_TYPE_AUTO_SENSOR;
	} else {
	    if (ecmd->speed == SPEED_1000) {
		if (ecmd->duplex != DUPLEX_FULL) {
	            printk(KERN_WARNING"can't force to 1000MHalf !\n");
		    ret_val = -EINVAL;
		    goto exit_sset;				
		}
		hw->MediaType = MEDIA_TYPE_1000M_FULL;
	    } else if (ecmd->speed == SPEED_100) {
		if (ecmd->duplex == DUPLEX_FULL) {
		    hw->MediaType = MEDIA_TYPE_100M_FULL;
		} else {
		    hw->MediaType = MEDIA_TYPE_100M_HALF;
		}
	    } else {
		if (ecmd->duplex == DUPLEX_FULL) {
	            hw->MediaType = MEDIA_TYPE_10M_FULL;
		} else {
		    hw->MediaType = MEDIA_TYPE_10M_HALF;
		}
	    }
	}
	switch (hw->MediaType)
	{
	case MEDIA_TYPE_AUTO_SENSOR:
		ecmd->advertising = 
					  ADVERTISED_10baseT_Half |
					  ADVERTISED_10baseT_Full |
					  ADVERTISED_100baseT_Half |
					  ADVERTISED_100baseT_Full |
					  ADVERTISED_1000baseT_Full|
					  ADVERTISED_Autoneg |
					  ADVERTISED_TP;
		break;
	case MEDIA_TYPE_1000M_FULL:
		ecmd->advertising = 
						  ADVERTISED_1000baseT_Full|
						  ADVERTISED_Autoneg |
						  ADVERTISED_TP;
		break;
	default:
		ecmd->advertising = 0;
		break;
	} 

	if(at_phy_setup_autoneg_adv(hw)) {
		ret_val = -EINVAL;
		goto exit_sset;
	}

    if (hw->MediaType == MEDIA_TYPE_AUTO_SENSOR ||
    	hw->MediaType == MEDIA_TYPE_1000M_FULL) {
    	phy_data = MII_CR_RESET | MII_CR_AUTO_NEG_EN;
    } else {
        switch (hw->MediaType)
    	{
    	case MEDIA_TYPE_100M_FULL:
    		phy_data = MII_CR_FULL_DUPLEX|MII_CR_SPEED_100|MII_CR_RESET;
    		break;
    	case MEDIA_TYPE_100M_HALF:
    		phy_data = MII_CR_SPEED_100|MII_CR_RESET;
    		break;
    	case MEDIA_TYPE_10M_FULL:
    		phy_data = MII_CR_FULL_DUPLEX|MII_CR_SPEED_10|MII_CR_RESET;
    		break;
    	default: // MEDIA_TYPE_10M_HALF:
    		phy_data = MII_CR_SPEED_10|MII_CR_RESET;
    		break;
    	}
    }
    
    at_write_phy_reg(hw, MII_BMCR, phy_data);

exit_sset: 
    if (ret_val) {
        hw->MediaType = old_media_type;
    }
    
    if(netif_running(adapter->netdev)) {
	at_up(adapter);
    } else if (!ret_val) {
	at_reset(adapter);
    }

    return ret_val;
}

static void
at_ethtool_gset(struct at_adapter *adapter, struct ethtool_cmd *ecmd)
{
	struct at_hw *hw = &adapter->hw;


	ecmd->supported = (SUPPORTED_10baseT_Half |
	                   SUPPORTED_10baseT_Full |
	                   SUPPORTED_100baseT_Half |
	                   SUPPORTED_100baseT_Full |
	                   SUPPORTED_1000baseT_Full|
	                   SUPPORTED_Autoneg |
	                   SUPPORTED_TP);

	ecmd->advertising = ADVERTISED_TP;

	if (hw->MediaType == MEDIA_TYPE_AUTO_SENSOR ||
	    hw->MediaType == MEDIA_TYPE_1000M_FULL) {
		ecmd->advertising |= ADVERTISED_Autoneg;
		if (hw->MediaType == MEDIA_TYPE_AUTO_SENSOR) {
			ecmd->advertising |= ADVERTISED_Autoneg;
			
			ecmd->advertising |= 
						(ADVERTISED_10baseT_Half 	|
						 ADVERTISED_10baseT_Full 	|
						 ADVERTISED_100baseT_Half	|
						 ADVERTISED_100baseT_Full	|
						 ADVERTISED_1000baseT_Full  );
		} else {
			ecmd->advertising |= 
						(ADVERTISED_1000baseT_Full);
		}
	}
	ecmd->port = PORT_TP;
	ecmd->phy_address = 0;
	ecmd->transceiver = XCVR_INTERNAL;

	if(netif_carrier_ok(adapter->netdev)) 
	{
        uint16_t link_speed, link_duplex;
        
		at_get_speed_and_duplex(hw, &link_speed, &link_duplex);
		ecmd->speed = link_speed;
		if(link_duplex == FULL_DUPLEX)
			ecmd->duplex = DUPLEX_FULL;
		else
			ecmd->duplex = DUPLEX_HALF;
	} else {
		ecmd->speed = -1;
		ecmd->duplex = -1;
	}

	if (hw->MediaType == MEDIA_TYPE_AUTO_SENSOR ||
	    hw->MediaType == MEDIA_TYPE_1000M_FULL) {
		ecmd->autoneg = AUTONEG_ENABLE;
	} else {
		ecmd->autoneg = AUTONEG_DISABLE;
	}
}


#ifdef	ETHTOOL_GDRVINFO
static void
at_ethtool_gdrvinfo(struct at_adapter *adapter,
                       struct ethtool_drvinfo *drvinfo)
{
	strncpy(drvinfo->driver,  at_driver_name, 32);
	strncpy(drvinfo->version, at_driver_version, 32);
	strncpy(drvinfo->fw_version, "N/A", 32);
	strncpy(drvinfo->bus_info, pci_name(adapter->pdev), 32);
#ifdef  ETHTOOL_GEEPROM
	drvinfo->eedump_len = 48;
#endif//ETHTOOL_GEEPROM	
}
#endif	/* ETHTOOL_GDRVINFO */

#ifdef	ETHTOOL_GRINGPARAM
static int
at_ethtool_gring(struct at_adapter *adapter,
                    struct ethtool_ringparam *ring)
{
	struct at_tpd_ring *txdr = &adapter->tpd_ring;
	struct at_rfd_ring *rxdr = &adapter->rfd_ring;

	ring->rx_max_pending = 2048;
	ring->tx_max_pending = 1024;
	ring->rx_mini_max_pending = 0;
	ring->rx_jumbo_max_pending = 0;
	ring->rx_pending = rxdr->count;
	ring->tx_pending = txdr->count;
	ring->rx_mini_pending = 0;
	ring->rx_jumbo_pending = 0;

	return 0;
}
#endif /* ETHTOOL_GRINGPARAM */
#ifdef	ETHTOOL_SRINGPARAM
static int 
at_ethtool_sring(struct at_adapter *adapter,
                 struct ethtool_ringparam *ring)
{
	int err;
	struct at_tpd_ring *tpdr = &adapter->tpd_ring;
	struct at_rrd_ring *rrdr = &adapter->rrd_ring;
	struct at_rfd_ring *rfdr = &adapter->rfd_ring;
	
	struct at_tpd_ring tpd_old, tpd_new;
	struct at_rfd_ring rfd_old, rfd_new;
	struct at_rrd_ring rrd_old , rrd_new;


	tpd_old = adapter->tpd_ring;
	rfd_old = adapter->rfd_ring;
	rrd_old = adapter->rrd_ring;
	
	if(netif_running(adapter->netdev))
		at_down(adapter);

	rfdr->count = (uint16_t)max(ring->rx_pending, (uint32_t)32);
	rfdr->count = rfdr->count>2048 ? 2048 : rfdr->count;
	rfdr->count = (rfdr->count+3)&~3;
	rrdr->count = rfdr->count;
	
	tpdr->count = (uint16_t)max(ring->tx_pending, (uint32_t)16);
	tpdr->count = tpdr->count>1024 ? 1024 : tpdr->count;
	tpdr->count = (tpdr->count+3)&~3;

	if(netif_running(adapter->netdev)) {
		/* try to get new resources before deleting old */
	    if ((err = at_setup_ring_resources(adapter)))
	        goto err_setup_ring;	
	
		
		/* save the new, restore the old in order to free it,
		 * then restore the new back again */	
	
		rfd_new = adapter->rfd_ring;
		rrd_new = adapter->rrd_ring;
		tpd_new = adapter->tpd_ring;
		adapter->rfd_ring = rfd_old;
		adapter->rrd_ring = rrd_old;
		adapter->tpd_ring = tpd_old;
		at_free_ring_resources(adapter);
        adapter->rfd_ring = rfd_new;
		adapter->rrd_ring = rrd_new;
		adapter->tpd_ring = tpd_new;

		if((err = at_up(adapter)))
			return err;
	}
	return 0;

err_setup_ring:
	adapter->rfd_ring = rfd_old;
	adapter->rrd_ring = rrd_old;
	adapter->tpd_ring = tpd_old;
	at_up(adapter);
	return err;
}
#endif /* ETHTOOL_SRINGPARAM */
#ifdef	ETHTOOL_GPAUSEPARAM
static int
at_ethtool_gpause(struct at_adapter *adapter,
                     struct ethtool_pauseparam *epause)
{
	struct at_hw *hw = &adapter->hw;
	
	if (hw->MediaType == MEDIA_TYPE_AUTO_SENSOR ||
	    hw->MediaType == MEDIA_TYPE_1000M_FULL) {
		epause->autoneg = AUTONEG_ENABLE;
	} else {
		epause->autoneg = AUTONEG_DISABLE;
	}
	
	epause->rx_pause = 1;
	epause->tx_pause = 1;

	return 0;
}
#endif /* ETHTOOL_GPAUSEPARAM */
#ifdef	ETHTOOL_SPAUSEPARAM
static int
at_ethtool_spause(struct at_adapter *adapter,
                     struct ethtool_pauseparam *epause)
{
	struct at_hw *hw = &adapter->hw;
	
	if (hw->MediaType == MEDIA_TYPE_AUTO_SENSOR ||
	    hw->MediaType == MEDIA_TYPE_1000M_FULL) {
		epause->autoneg = AUTONEG_ENABLE;
	} else {
		epause->autoneg = AUTONEG_DISABLE;
	}
	
	epause->rx_pause = 1;
	epause->tx_pause = 1;
	return 0;
	
}
#endif /* ETHTOOL_SPAUSEPARAM */


int
at_ethtool_ioctl(struct net_device *netdev, struct ifreq *ifr)
{
	struct at_adapter *adapter = netdev->priv;
	void *addr = ifr->ifr_data;
	uint32_t cmd;

	if(get_user(cmd, (uint32_t *) addr))
		return -EFAULT;

	//michael add 2005-11-17/	
	DEBUGOUT("enter at_ethtool_ioctl\n");
	switch(cmd) {
	case ETHTOOL_GSET: {
		struct ethtool_cmd ecmd = {ETHTOOL_GSET};
		at_ethtool_gset(adapter, &ecmd);
		if(copy_to_user(addr, &ecmd, sizeof(ecmd)))
			return -EFAULT;
		return 0;
	}
	case ETHTOOL_SSET: {
		struct ethtool_cmd ecmd;
		if(copy_from_user(&ecmd, addr, sizeof(ecmd)))
			return -EFAULT;
		return at_ethtool_sset(adapter, &ecmd);
	}
#ifdef	ETHTOOL_GDRVINFO
	case ETHTOOL_GDRVINFO: {
		struct ethtool_drvinfo drvinfo = {ETHTOOL_GDRVINFO};
		at_ethtool_gdrvinfo(adapter, &drvinfo);
		if(copy_to_user(addr, &drvinfo, sizeof(drvinfo)))
			return -EFAULT;
		return 0;
	}
#endif	/* ETHTOOL_GDRVINFO */
#ifdef	ETHTOOL_GSTRINGS
	case ETHTOOL_GSTRINGS: {
		struct ethtool_gstrings gstrings = { ETHTOOL_GSTRINGS };
		char *strings = NULL;
		int err = 0;

		if(copy_from_user(&gstrings, addr, sizeof(gstrings)))
			return -EFAULT;
		switch(gstrings.string_set) 
		{
#ifdef	ETHTOOL_GSTATS
		case ETH_SS_STATS: 
		{
            int i;
            gstrings.len = AT_STATS_LEN;
            strings = kmalloc(AT_STATS_LEN * ETH_GSTRING_LEN,
            		  GFP_KERNEL);
            if(!strings)
            	return -ENOMEM;
            for(i=0; i < AT_STATS_LEN; i++) {
            	memcpy(&strings[i * ETH_GSTRING_LEN],
            	       at_gstrings_stats[i].stat_string,
            	       ETH_GSTRING_LEN);
            }
		break;
        }
#endif	/* ETHTOOL_GSTATS */
		default:
			return -EOPNOTSUPP;
		}
		if(copy_to_user(addr, &gstrings, sizeof(gstrings)))
			err = -EFAULT;
		addr += offsetof(struct ethtool_gstrings, data);
		if(!err && copy_to_user(addr, strings, gstrings.len * ETH_GSTRING_LEN))
			err = -EFAULT;

		kfree(strings);
		return err;
	}
#endif	/* ETHTOOL_GSTRINGS */
#ifdef	ETHTOOL_NWAY_RST
	case ETHTOOL_NWAY_RST: {
		struct at_hw* hw = &adapter->hw;
		if(netif_running(netdev)) {
			uint16_t phy_data;
			at_down(adapter);
			
			if (hw->MediaType == MEDIA_TYPE_AUTO_SENSOR ||
    			hw->MediaType == MEDIA_TYPE_1000M_FULL) {
    			phy_data = MII_CR_RESET | MII_CR_AUTO_NEG_EN;
    		} else {
	        	switch (hw->MediaType)
	    		{
	    		case MEDIA_TYPE_100M_FULL:
	    			phy_data = MII_CR_FULL_DUPLEX|MII_CR_SPEED_100|MII_CR_RESET;
	    			break;
	    		case MEDIA_TYPE_100M_HALF:
	    			phy_data = MII_CR_SPEED_100|MII_CR_RESET;
	    			break;
	    		case MEDIA_TYPE_10M_FULL:
	    			phy_data = MII_CR_FULL_DUPLEX|MII_CR_SPEED_10|MII_CR_RESET;
	    			break;
	    		default: // MEDIA_TYPE_10M_HALF:
	    			phy_data = MII_CR_SPEED_10|MII_CR_RESET;
	    			break;
	    		}
    		}
    		at_write_phy_reg(hw, MII_BMCR, phy_data);
			at_up(adapter);
		}
		return 0;
	}
#endif	/* ETHTOOL_NWAY_RST */
#ifdef	ETHTOOL_GLINK
	case ETHTOOL_GLINK: {
		struct ethtool_value link = {ETHTOOL_GLINK};
		link.data = netif_carrier_ok(netdev);
		if(copy_to_user(addr, &link, sizeof(link)))
			return -EFAULT;
		return 0;
	}
#endif	/* ETHTOOL_GLINK */
#ifdef	ETHTOOL_GWOL
	case ETHTOOL_GWOL: {
		struct ethtool_wolinfo wol = {ETHTOOL_GWOL};
		at_ethtool_gwol(adapter, &wol);
		if(copy_to_user(addr, &wol, sizeof(wol)) != 0)
			return -EFAULT;
		return 0;
	}
#endif	/* ETHTOOL_GWOL */
#ifdef	ETHTOOL_SWOL
	case ETHTOOL_SWOL: {
		struct ethtool_wolinfo wol;
		if(copy_from_user(&wol, addr, sizeof(wol)) != 0)
			return -EFAULT;
		return at_ethtool_swol(adapter, &wol);
	}
#endif	/* ETHTOOL_SWOL */

#ifdef	ETHTOOL_GRINGPARAM
	case ETHTOOL_GRINGPARAM: {
		struct ethtool_ringparam ering = {ETHTOOL_GRINGPARAM};
		at_ethtool_gring(adapter, &ering);
		if(copy_to_user(addr, &ering, sizeof(ering)))
			return -EFAULT;
		return 0;
	}
#endif	/* ETHTOOL_GRINGPARAM */
#ifdef	ETHTOOL_SRINGPARAM
	case ETHTOOL_SRINGPARAM: {
		struct ethtool_ringparam ering;
		if(copy_from_user(&ering, addr, sizeof(ering)))
			return -EFAULT;
		return at_ethtool_sring(adapter, &ering);
	}
#endif	/* ETHTOOL_SRINGPARAM */
#ifdef	ETHTOOL_GPAUSEPARAM
	case ETHTOOL_GPAUSEPARAM: {
		struct ethtool_pauseparam epause = {ETHTOOL_GPAUSEPARAM};
		at_ethtool_gpause(adapter, &epause);
		if(copy_to_user(addr, &epause, sizeof(epause)))
			return -EFAULT;
		return 0;
	}
#endif	/* ETHTOOL_GPAUSEPARAM */
#ifdef	ETHTOOL_SPAUSEPARAM
	case ETHTOOL_SPAUSEPARAM: {
		struct ethtool_pauseparam epause;
		if(copy_from_user(&epause, addr, sizeof(epause)))
			return -EFAULT;
		return at_ethtool_spause(adapter, &epause);
	}
#endif	/* ETHTOOL_SPAUSEPARAM */
#ifdef	ETHTOOL_GSTATS
	case ETHTOOL_GSTATS: {
		struct {
			struct ethtool_stats eth_stats;
			uint64_t data[AT_STATS_LEN];
		} stats = { {ETHTOOL_GSTATS, AT_STATS_LEN} };
		int i;

		for(i = 0; i < AT_STATS_LEN; i++)
			stats.data[i] = (at_gstrings_stats[i].sizeof_stat ==
					sizeof(uint64_t)) ?
				*(uint64_t *)((char *)adapter +
					at_gstrings_stats[i].stat_offset) :
				*(uint32_t *)((char *)adapter +
					at_gstrings_stats[i].stat_offset);
		if(copy_to_user(addr, &stats, sizeof(stats)))
			return -EFAULT;
		return 0;
	}
#endif	/* ETHTOOL_GSTATS */
#ifdef	ETHTOOL_GRXCSUM
	case ETHTOOL_GRXCSUM: {
		struct ethtool_value edata = { ETHTOOL_GRXCSUM };

		edata.data = 1;
		if (copy_to_user(addr, &edata, sizeof(edata)))
			return -EFAULT;
		return 0;
	}
#endif	/* ETHTOOL_GRXCSUM */
#ifdef	ETHTOOL_GTXCSUM
	case ETHTOOL_GTXCSUM: {
		struct ethtool_value edata = { ETHTOOL_GTXCSUM };

		edata.data =
			(netdev->features & NETIF_F_HW_CSUM) != 0;
		if (copy_to_user(addr, &edata, sizeof(edata)))
			return -EFAULT;
		return 0;
	}
#endif	/* ETHTOOL_GTXCSUM */
#ifdef	ETHTOOL_STXCSUM
	case ETHTOOL_STXCSUM: {
		struct ethtool_value edata;

		if (copy_from_user(&edata, addr, sizeof(edata)))
			return -EFAULT;

		if (edata.data)
			netdev->features |= NETIF_F_HW_CSUM;
		else
			netdev->features &= ~NETIF_F_HW_CSUM;

		return 0;
	}
#endif	/* ETHTOOL_STXCSUM */
#ifdef	ETHTOOL_GSG
	case ETHTOOL_GSG: {
		struct ethtool_value edata = { ETHTOOL_GSG };

		edata.data =
			(netdev->features & NETIF_F_SG) != 0;
		if (copy_to_user(addr, &edata, sizeof(edata)))
			return -EFAULT;
		return 0;
	}
#endif	/* ETHTOOL_GSG */
#ifdef	ETHTOOL_SSG
	case ETHTOOL_SSG: {
		struct ethtool_value edata;

		if (copy_from_user(&edata, addr, sizeof(edata)))
			return -EFAULT;

		if (edata.data)
			netdev->features |= NETIF_F_SG;
		else
			netdev->features &= ~NETIF_F_SG;

		return 0;
	}
#endif	/* ETHTOOL_SSG */
#ifdef NETIF_F_TSO
#ifdef ETHTOOL_GTSO
	case ETHTOOL_GTSO: {
		struct ethtool_value edata = { ETHTOOL_GTSO };

		edata.data = (netdev->features & NETIF_F_TSO) != 0;
		if (copy_to_user(addr, &edata, sizeof(edata)))
			return -EFAULT;
		return 0;
	}
#endif /* ETHTOOL_GTSO */
#ifdef ETHTOOL_STSO
	case ETHTOOL_STSO: {
		struct ethtool_value edata;

		if (copy_from_user(&edata, addr, sizeof(edata)))
			return -EFAULT;

		if (edata.data)
			netdev->features |= NETIF_F_TSO;
		else
			netdev->features &= ~NETIF_F_TSO;

		return 0;
	}
#endif /* ETHTOOL_STSO */
#endif
	default:
		return -EOPNOTSUPP;
	}
}

#endif//SIOCETHTOOL
